<?php declare(strict_types = 1);

namespace EshopStock\Model\Subscribers;

use Core\Model\Event\Event;
use EshopStock\Model\Repository\SupplyProducts;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class OrderItemsSubscriber implements EventSubscriberInterface
{
	protected SupplyProducts $supplyProducts;

	public function __construct(SupplyProducts $supplyProducts)
	{
		$this->supplyProducts = $supplyProducts;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orderItems.loadMoreData' => 'loadMoreData',
		];
	}

	public function loadMoreData(Event $event): void
	{
		if (!isset($event->data['orderItems']) || empty($event->data['orderItems'])) {
			return;
		}

		$itemsByKey   = [];
		$itemsByOrder = [];
		foreach ($event->data['orderItems'] as $k => $v) {
			$itemsByKey[$v->order->getId() . '_' . $v->getProductId()] = $k;
			$itemsByOrder[$v->order->getId()][$v->getId()]             = $v;
		}

		foreach ($itemsByOrder as $orderId => $orderItems) {
			foreach ($this->supplyProducts->getEr()->createQueryBuilder('sp')
				         ->select('IDENTITY(sp.product) as product, IDENTITY(sp.order) as order')
				         ->where('sp.order = :order')
				         ->setParameters([
					         'order' => $orderId,
				         ])
				         ->getQuery()->getArrayResult() as $row) {
				$key = $itemsByKey[$row['order'] . '_' . $row['product']] ?? null;

				if ($key !== null) {
					$event->data['orderItems'][$key]->setMoreDataValue('stockSupplyAssigned', true);
				}
			}
		}
	}

}
