<?php declare(strict_types=1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20200115193624 extends AbstractMigration
{
	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('CREATE TABLE eshop_stock__products_to_order_orders (id INT AUTO_INCREMENT NOT NULL, order_id INT DEFAULT NULL, product_to_order_id INT DEFAULT NULL, INDEX IDX_71174C9C8D9F6D38 (order_id), INDEX IDX_71174C9CECE96D89 (product_to_order_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_stock__product_to_order (id INT AUTO_INCREMENT NOT NULL, product_id INT DEFAULT NULL, quantity INT NOT NULL, INDEX IDX_B0B9E5154584665A (product_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_stock__stock (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_stock__supply (id INT AUTO_INCREMENT NOT NULL, supplier_id INT DEFAULT NULL, stock_id INT DEFAULT NULL, invoice_number VARCHAR(255) NOT NULL, date_supply DATETIME NOT NULL, INDEX IDX_C485E5072ADD6D8C (supplier_id), INDEX IDX_C485E507DCD6110 (stock_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE eshop_stock__supply_product (id INT AUTO_INCREMENT NOT NULL, product_id INT DEFAULT NULL, supply_id INT DEFAULT NULL, order_id INT DEFAULT NULL, purchasePrice NUMERIC(10, 2) NOT NULL, written_off TINYINT(1) DEFAULT \'0\' NOT NULL, INDEX IDX_AEB7AE094584665A (product_id), INDEX IDX_AEB7AE09FF28C0D8 (supply_id), INDEX IDX_AEB7AE098D9F6D38 (order_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE eshop_stock__products_to_order_orders ADD CONSTRAINT FK_71174C9C8D9F6D38 FOREIGN KEY (order_id) REFERENCES eshop_orders__order (id)');
		$this->addSql('ALTER TABLE eshop_stock__products_to_order_orders ADD CONSTRAINT FK_71174C9CECE96D89 FOREIGN KEY (product_to_order_id) REFERENCES eshop_stock__product_to_order (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_stock__product_to_order ADD CONSTRAINT FK_B0B9E5154584665A FOREIGN KEY (product_id) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_stock__supply ADD CONSTRAINT FK_C485E5072ADD6D8C FOREIGN KEY (supplier_id) REFERENCES eshop_catalog__supplier (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_stock__supply ADD CONSTRAINT FK_C485E507DCD6110 FOREIGN KEY (stock_id) REFERENCES eshop_stock__stock (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_stock__supply_product ADD CONSTRAINT FK_AEB7AE094584665A FOREIGN KEY (product_id) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_stock__supply_product ADD CONSTRAINT FK_AEB7AE09FF28C0D8 FOREIGN KEY (supply_id) REFERENCES eshop_stock__supply (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE eshop_stock__supply_product ADD CONSTRAINT FK_AEB7AE098D9F6D38 FOREIGN KEY (order_id) REFERENCES eshop_orders__order (id) ON DELETE SET NULL');
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE eshop_stock__products_to_order_orders DROP FOREIGN KEY FK_71174C9CECE96D89');
		$this->addSql('ALTER TABLE eshop_stock__supply DROP FOREIGN KEY FK_C485E507DCD6110');
		$this->addSql('ALTER TABLE eshop_stock__supply_product DROP FOREIGN KEY FK_AEB7AE09FF28C0D8');
		$this->addSql('DROP TABLE eshop_stock__products_to_order_orders');
		$this->addSql('DROP TABLE eshop_stock__product_to_order');
		$this->addSql('DROP TABLE eshop_stock__stock');
		$this->addSql('DROP TABLE eshop_stock__supply');
		$this->addSql('DROP TABLE eshop_stock__supply_product');
	}
}
