document.addEventListener('DOMContentLoaded', () => {
	const form      = document.querySelector('#frm-stocksTabs-supply-form');
	const btnSubmit = form.querySelector('[name="_submit"]');
	btnSubmit.addEventListener('click', () => {
		if (window.Nette.validateForm(form, true)) {
			btnSubmit.classList.add('btn-loading');
		}
	});

	const itemInput = document.getElementById('frm-stocksTabs-supply-form-item');
	if (itemInput) {
		itemInput.focus();
	}
});

if (!global.document.autocompleteResultItem) {
	global.document.autocompleteResultItem = {};
}

global.document.autocompleteResultItem['eshopStockSupplyFormItem'] = (data, source) => {
	let str = data.value.code1 + ' | ';

	if (data.value.manufacturer) {
		str += data.value.manufacturer + ' - ';
	}

	str += data.value.name;

	source.innerHTML = str;
};

document.addEventListener('autocompleteOnSelection', e => {
	if (e.detail.name === "eshopStockSupplyFormItem") {
		const input = document.querySelector('[data-autocomplete-name="' + e.detail.name + '"]');
		const data  = e.detail.selection.value;

		global.naja.makeRequest('post', input.dataset.saveAndGetProducts, {
			productId: data.id,
		}, {
			history: false,
		}).then(response => {
			input.value = '';

			const itemInput = document.getElementById('frm-stocksTabs-supply-form-item');
			if (itemInput) {
				itemInput.focus();
			}
		});
	}
})

