<?php declare(strict_types = 1);

namespace EshopStock\AdminModule\Components;

use Core\Model\UI\BaseControl;
use EshopCatalog\AdminModule\Model\Products;
use EshopCatalog\Model\Entities\ProductListener;
use EshopStock\AdminModule\Presenters\DefaultPresenter;
use EshopStock\Model\Entities\Supply;
use EshopStock\Model\Repository\SupplyProducts;
use Nette\Security\User;

/**
 * @property-read DefaultPresenter $presenter
 */
class SupplyDetail extends BaseControl
{
	public function __construct(
		protected Supply         $supply,
		protected SupplyProducts $supplyProducts,
		protected Products       $products,
		protected User           $user,
	)
	{
	}

	public function render(): void
	{
		$this->template->item = $this->supply;
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ========= HANDLE
	 */

	/**
	 * @param int|string $supplyProductId
	 */
	public function handleWriteOff($supplyProductId): void
	{
		if (!$this->isAllowedEdit()) {
			return;
		}
		ProductListener::$updateVariant = false;

		$supplyProduct = $this->supplyProducts->get((int) $supplyProductId);

		if (!$supplyProduct) {
			return;
		}

		$product = $this->products->get($supplyProduct->product->getId());

		if (!$product) {
			return;
		}

		$supplyProduct->setWrittenOff();
		$product->quantity -= 1;

		$this->em->persist($supplyProduct);
		$this->em->persist($product);
		$this->em->flush();

		$this->redrawControl('detail');
	}

	public function isAllowedEdit(): bool
	{
		return $this->user->isAllowed($this->presenter->getFullModuleName(), 'edit');
	}

}
