<?php declare(strict_types = 1);

namespace EshopStock\DI;

use Core\DI\CompilerExtension;
use Nette\PhpGenerator\ClassType;
use Override;

class EshopStockExtension extends CompilerExtension
{
	#[Override]
	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	#[Override]
	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['EshopStock' => 'EshopStock\*Module\Presenters\*Presenter']);
	}

	#[Override]
	public function afterCompile(ClassType $class): void
	{
		parent::afterCompile($class);
		$init = $class->getMethod('initialize');
		$this->getContainerBuilder();

		$init->addBody('EshopStock\Model\EshopStockConfig::setParams($this->parameters[\'eshopStock\']);');
	}

}
