<?php declare(strict_types = 1);

namespace EshopStock\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\Order;
use EshopStock\Model\Listeners\ProductsToOrderOrdersListener;

#[ORM\Table('eshop_stock__products_to_order_orders')]
#[ORM\Entity]
#[ORM\EntityListeners([ProductsToOrderOrdersListener::class])]
class ProductsToOrderOrders
{
	use TId;

	#[ORM\JoinColumn(name: 'order_id', referencedColumnName: 'id')]
	#[ORM\ManyToOne(targetEntity: Order::class, cascade: ['persist'])]
	public ?Order $order = null;

	#[ORM\JoinColumn(name: 'product_to_order_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: ProductToOrder::class, inversedBy: 'orders')]
	public ?ProductToOrder $productToOrder = null;

	public function __construct(Order $order, ProductToOrder $productToOrder)
	{
		$this->order          = $order;
		$this->productToOrder = $productToOrder;
	}

}
