<?php declare(strict_types = 1);

namespace EshopStock\Model\Entities;

use Core\Model\Entities\TId;
use DateTime;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Supplier;

#[ORM\Table('eshop_stock__supply')]
#[ORM\Entity]
class Supply
{
	use TId;

	#[ORM\JoinColumn(name: 'supplier_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Supplier::class)]
	public ?Supplier $supplier = null;

	#[ORM\Column(type: Types::STRING, length: 255)]
	public string $invoiceNumber;

	#[ORM\Column(type: Types::DATETIME_MUTABLE)]
	public ?DateTime $dateSupply;

	/** @var Collection<SupplyProduct> */
	#[ORM\OneToMany(mappedBy: 'supply', targetEntity: SupplyProduct::class, cascade: ['all'])]
	protected Collection $supplyProducts;

	#[ORM\JoinColumn(name: 'stock_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Stock::class)]
	protected ?Stock $stock = null;

	public function __construct(Stock $stock, Supplier $supplier, string $invoiceNumber, DateTime $dateSupply)
	{
		$this->stock          = $stock;
		$this->supplier       = $supplier;
		$this->invoiceNumber  = $invoiceNumber;
		$this->dateSupply     = $dateSupply;
		$this->supplyProducts = new ArrayCollection;
	}

	/**
	 * @return Collection<SupplyProduct>
	 */
	public function getSupplyProducts() { return $this->supplyProducts; }

	public function addSupplyProduct(SupplyProduct $supplyProduct): void
	{
		$this->supplyProducts->add($supplyProduct);
	}

	public function getPurchasePriceSum(): float
	{
		$sum = 0;

		foreach ($this->supplyProducts->toArray() as $supplyProduct) {
			$sum += $supplyProduct->purchasePrice;
		}

		return $sum;
	}

}
