<?php declare(strict_types = 1);

namespace EshopStock\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Product;
use EshopOrders\Model\Entities\Order;
use Nette\Utils\DateTime;

#[ORM\Table('eshop_stock__supply_product')]
#[ORM\Entity]
class SupplyProduct
{
	use TId;

	#[ORM\JoinColumn(name: 'product_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Product::class)]
	public ?Product $product = null;

	#[ORM\JoinColumn(name: 'supply_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Supply::class)]
	public ?Supply $supply = null;

	/**
	 * @var float|string
	 */
	#[ORM\Column(name: 'purchasePrice', type: Types::DECIMAL, precision: 10, scale: 2)]
	public $purchasePrice;

	#[ORM\JoinColumn(name: 'order_id', referencedColumnName: 'id', nullable: true, onDelete: 'SET NULL')]
	#[ORM\ManyToOne(targetEntity: Order::class, cascade: ['persist'])]
	public ?Order $order = null;

	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
	public ?\DateTime $writtenOffDate = null;

	public function __construct(Product $product, Supply $supply, string $purchasePrice)
	{
		$this->product       = $product;
		$this->supply        = $supply;
		$this->purchasePrice = $purchasePrice;
	}

	public function isWrittenOff(): bool
	{
		return $this->writtenOffDate !== null;
	}

	public function hasOrder(): bool
	{
		return $this->order !== null;
	}

	public function setWrittenOff(): void
	{
		$this->writtenOffDate = new DateTime;
	}

}
