<?php declare(strict_types = 1);

namespace EshopStock\Model\Listeners;

use Core\Model\Entities\EntityManagerDecorator;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use EshopStock\Model\Entities\ProductToOrder;

;

class ProductToOrderOrderListener
{
	public function __construct(
		protected EntityManagerDecorator $em
	)
	{
	}

	#[ORM\PostUpdate]
	public function postUpdateHandler(ProductToOrder $entity, LifecycleEventArgs $events): void
	{
		if ($entity->quantity >= 0) {
			$this->em->remove($entity);
		}
	}
}
