<?php declare(strict_types = 1);

namespace EshopStock\Model\Listeners;

use Core\Model\Entities\EntityManagerDecorator;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use EshopStock\Model\Entities\ProductsToOrderOrders;

;

class ProductsToOrderOrdersListener
{
	public function __construct(
		protected EntityManagerDecorator $em,
	)
	{
	}

	#[ORM\PostRemove]
	public function postRemoveHandler(ProductsToOrderOrders $entity, LifecycleEventArgs $events): void
	{
		if ($entity->productToOrder->orders->count() === 0) {
			$this->em->remove($entity->productToOrder);
		}
	}
}
