<?php declare(strict_types = 1);

namespace EshopStock\Model\Repository;

use Core\Model\Helpers\BaseEntityService;
use Doctrine\ORM\QueryBuilder;
use EshopCatalog\AdminModule\Model\Products;
use EshopStock\Model\Entities\ProductToOrder;

/**
 * @method ProductToOrder|null get(int $id)
 * @method ProductToOrder[] getAll()
 */
class ProductsToOrder extends BaseEntityService
{
	/** @var string */
	protected $entityClass = ProductToOrder::class;

	public function __construct(
		protected Products $products,
	)
	{
	}

	public function getOneByProduct(int $productId): ?ProductToOrder
	{
		$qb = $this->getEr()->createQueryBuilder('pto');
		$qb->select('pto')
			->where($qb->expr()->eq('pto.product', $productId))
			->setMaxResults(1);

		return $qb->getQuery()->getOneOrNullResult();
	}

	public function getQueryBuilder(): QueryBuilder
	{
		return $this->getEr()->createQueryBuilder('pto');
	}

}
