<?php declare(strict_types = 1);

namespace EshopStock\Model\Repository;

use Core\Model\Helpers\BaseEntityService;
use Doctrine\ORM\QueryBuilder;
use EshopStock\Model\Entities\Stock;
use EshopStock\Model\EshopStockConfig;
use Override;

/**
 * @method Stock|null get(int $id)
 */
class Stocks extends BaseEntityService
{
	/** @var string */
	protected $entityClass = Stock::class;

	public function getQueryBuilder(): QueryBuilder
	{
		$qb = $this->getEr()->createQueryBuilder('s');
		$qb->addOrderBy('s.name');

		return $qb;
	}

	/**
	 * @return Stock[]
	 */
	#[Override]
	public function getAll(): array
	{
		return $this->getQueryBuilder()->getQuery()->getResult();
	}

	public function getDefaultStock(): ?Stock
	{
		$defaultStockId = EshopStockConfig::load('defaultStockId');
		$default        = $this->getQueryBuilder()
			->andWhere('s.id = :stockId')
			->setParameter('stockId', $defaultStockId)
			->getQuery()
			->getOneOrNullResult();

		if (!$default) {
			$default = new Stock('Sklad');
			$this->em->persist($default);
			$this->em->flush();
		}

		return $default;
	}

}
