<?php declare(strict_types = 1);

namespace EshopStock\Model\Repository;

use Contributte\Translation\Translator;
use Core\Model\Entities\EntityManagerDecorator;
use EshopCatalog\AdminModule\Model\Products;
use Nette\Http\Session;
use Nette\Http\SessionSection;

class TemporarySupplyProducts
{
	protected SessionSection $sessionSection;

	public function __construct(
		Session                          $session,
		protected Products               $products,
		protected Translator             $translator,
		protected EntityManagerDecorator $em
	)
	{
		$this->sessionSection = $session->getSection('temporarySupplyProducts');
	}

	public function addProduct(int $productId, int $quantity = null, int $purchasePrice = null, float $recyclingFee = null): void
	{
		$data = ['productId' => $productId, 'quantity' => $quantity, 'purchasePrice' => $purchasePrice, 'recyclingFee' => $recyclingFee];
		if ($this->sessionSection->offsetExists('products')) {
			$this->sessionSection->offsetSet('products', array_merge($this->sessionSection->offsetGet('products'), [$data]));
		} else {
			$this->sessionSection->offsetSet('products', [$data]);
		}
	}

	public function updateProduct(int $key, array $data): void
	{
		$products = $this->sessionSection->offsetGet('products');
		foreach ($products as $k => &$product) {
			if ($key === $k) {
				foreach ($data as $k2 => $d) {
					$product[$k2] = $d;
				}
				break;
			}
		}
		$this->sessionSection->offsetSet('products', $products);
	}

	public function loadProducts(): array
	{
		$arr = [];
		$ids = [];

		foreach ($this->sessionSection->products as $row) {
			$arr[] = $row;
			$ids[] = $row['productId'];
		}

		if ($arr === []) {
			return [];
		}

		$productsData = [];
		foreach ($this->em->getConnection()->fetchAllAssociative("SELECT p.id, p.code1, pt.name, p.quantity, p.purchase_price, p.recycling_fee, p.price, p.id_vat_rate, p.id_manufacturer
				FROM eshop_catalog__product p
				INNER JOIN eshop_catalog__product_texts pt ON pt.id = p.id AND pt.lang = '" . $this->translator->getLocale() . "'
				WHERE p.id IN (" . implode(',', $ids) . ")") as $row) {
			$productsData[$row['id']] = $row;
		}

		$manufacturers = $this->em->getConnection()->fetchAllKeyValue("SELECT id, name FROM eshop_catalog__manufacturer");
		$vatRates      = $this->em->getConnection()->fetchAllKeyValue("SELECT id, rate FROM eshop_catalog__vat_rate");


		$result = [];
		foreach ($arr as $product) {
			$p = $productsData[$product['productId']] ?? null;

			if (!$p) {
				continue;
			}

			$result[] = [
				'productId'     => $product['productId'],
				'name'          => $p['code1'] . ' - ' . $p['name'],
				'quantity'      => $product['quantity'],
				'purchasePrice' => $product['purchasePrice'],
				'recyclingFee'  => $p['recycling_fee'] ?: 0,
				'sellingPrice'  => $p['price'],
				'manufacturer'  => $p['id_manufacturer'] ? $manufacturers[$p['id_manufacturer']] : null,
				'vat'           => $p['id_vat_rate'] ? $vatRates[$p['id_vat_rate']] : null,
			];
		}

		return $result;
	}

	public function clear(): void
	{
		$this->sessionSection->remove();
	}

}
