<?php declare(strict_types=1);

namespace Essox\Model;

use Core\Model\Helpers\BaseService;
use Nette\Utils\ArrayHash;
use Tracy\Debugger;

class XmlService extends BaseService
{
	/** @var [] */
	protected $parameters;
	
	function setParameters($params)
	{
		$this->parameters = ArrayHash::from($params);
	}
	
	public function getParameters()
	{
		return $this->parameters;
	}
	
	public function getHashedXml($price, $type = 'Calculation', $returnLink = '')
	{
		if (!$this->parameters['url'] || !$this->parameters['userName'] || !$this->parameters['code']) {
			throw new Exception("Essox module not properly configured");
		}
		
		$login = $this->parameters['userName'];
		$psw   = $this->parameters['code'];
		$time  = date("YmdHis");
		
		$sHashKey = $login . '#' . $psw . '#' . $price . '#' . $time;
		$sHashKey = sha1($sHashKey);
		
		$xml = new \SimpleXMLElement('<FinitServiceRequest/>', LIBXML_NOEMPTYTAG );
		$xml->addChild('Version', "1.0");
		$xml->addChild('ServiceName', $type);
		$baseParameters = $xml->addChild('BaseParameters');
		$baseParameters->addChild('UserName', $login);
		$baseParameters->addChild('Price', (string)$price);
		$baseParameters->addChild('Timestamp', $time);
		$baseParameters->addChild('HashKey', $sHashKey);
		$extParameters = $xml->addChild('ExtendedParameters');
		if ($type == 'NewContract') {
			$extParameters->addChild('CallbackURL', $returnLink);
		}
		
		//convert to string without the XML header
		$dom       = dom_import_simplexml($xml );
		$xmlString = $dom->ownerDocument->saveXML($dom->ownerDocument->documentElement, LIBXML_NOEMPTYTAG);
		
		$hash = base64_encode($xmlString);
		return $hash;
	}
}
