<?php declare(strict_types = 1);

namespace Essox\FrontModule\Components;

use Core\Model\UI\BaseControl;
use Essox\Model\XmlService;

class EssoxCalc extends BaseControl
{
	/** @var string */
	protected $code;
	
	/** @var string */
	protected $url;
	
	/** @var string */
	protected $userName;
	
	/** @var int */
	protected $minPrice;
	
	/** @var int */
	protected $price;
	
	/** @var XmlService */
	protected $xmlservice;
	
	public function __construct(XmlService $xmlservice)
	{
		$this->code = $xmlservice->getParameters()->code;
		$this->minPrice = $xmlservice->getParameters()->minPrice;
		$this->url = $xmlservice->getParameters()->url;
		$this->userName = $xmlservice->getParameters()->userName;
		
		$this->xmlservice = $xmlservice;
	}

	public function render()
	{
		if (!$this->code || !$this->userName || !$this->url) {
			return '';
		}
		
		$this->template->minPrice = $this->minPrice;
		$this->template->productPrice = $this->price;
		$this->template->render($this->getTemplateFile());
	}
	
	/*******************************************************************************************************************
	 * ============================== Handle
	 */
	
	public function handleGetUrl($price)
	{
		$presenter = $this->getPresenter();
		try {
			$price = max($price, 3000);
			$hash = $this->xmlservice->getHashedXml($price);
			$url = $this->url."?ESXCode=5&ESXAuth=".$hash;
			$this->template->calculatorUrl = $url;
		} catch (Exception $e) {
			$presenter->flashMessage('essox.calculator.urlFailed', Flashes::FLASH_DANGER);
		}
		
		if ($presenter->isAjax()) {
			$this->template->showModal            = true;
			$this->getPresenter()->payload->modal = 'essoxDialog';
			$this->redrawControl('calculatorDialog');
			$presenter->redrawControl('flashes');
		}
	}
	
	public function setPrice($price)
	{
		$this->price = $price;
	}
}
