<?php declare(strict_types = 1);

namespace Essox\FrontModule\Components;

use Core\Model\UI\BaseControl;
use Essox\Model\XmlService;

class EssoxPay extends BaseControl
{
	/** @var string */
	protected $code;
	
	/** @var string */
	protected $url;
	
	/** @var string */
	protected $userName;
	
	/** @var int */
	protected $minPrice;
	
	/** @var int */
	protected $price;
	
	/** @var string */
	protected $orderIdent;
	
	/** @var XmlService */
	protected $xmlservice;
	
	public function __construct(XmlService $xmlservice)
	{
		$this->code = $xmlservice->getParameters()->code;
		$this->minPrice = $xmlservice->getParameters()->minPrice;
		$this->url = $xmlservice->getParameters()->url;
		$this->userName = $xmlservice->getParameters()->userName;
		
		$this->xmlservice = $xmlservice;
	}

	public function render()
	{
		if (!$this->code || !$this->userName || !$this->url || !$this->price) {
			return '';
		}
		
		$link = $this->getPresenter()->link('//:EshopOrders:Front:Payment:paymentFinished', array('orderIdent' => $this->orderIdent));
		$hash = $this->xmlservice->getHashedXml(floor($this->price), 'NewContract', $link);
		$paymentData = array('ESXCode' => 5, 'ESXAuth' => $hash);
		
		$this->template->paymentUrl = $this->url;
		$this->template->paymentData = $paymentData;
		
		$this->template->render($this->getTemplateFile());
	}
	
	public function setParameters($price, $orderIdent)
	{
		$this->price      = $price;
		$this->orderIdent = $orderIdent;
	}
}
