<?php declare(strict_types = 1);

namespace Essox\DI;

use Core\DI\CompilerExtension;
use Nette\PhpGenerator\ClassType;

class EssoxExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Essox' => 'Essox\*Module\Presenters\*Presenter']);
	}

	public function afterCompile(ClassType $class)
	{
		parent::afterCompile($class);

		$init    = $class->methods["initialize"];
		$builder = $this->getContainerBuilder();

		$init->addBody('Essox\Model\EssoxConfig::setParams(?);', [$builder->parameters['essox']]);
	}
}
