<?php declare(strict_types = 1);

namespace Essox\FrontModule\Components;

use Core\Components\Flashes\Flashes;
use Core\Model\UI\BaseControl;
use Essox\Model\ApiService;
use Essox\Model\EssoxConfig;
use Exception;

class EssoxCalc extends BaseControl
{
	protected float $price;
	protected ?int  $productId;

	protected ApiService $apiService;

	public function __construct(
		float      $price,
		?int       $productId,
		ApiService $apiService
	)
	{
		$this->price     = $price;
		$this->productId = $productId;

		$this->apiService = $apiService;
	}

	public function render(): void
	{
		$minPrice = (float) EssoxConfig::load('api2.minPrice');
		if (!$this->apiService->isAllowed() || $this->price < $minPrice) {
			return;
		}

		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ============================== Handle
	 */

	public function handleGetUrl(): void
	{
		$presenter = $this->presenter;

		try {
			$url = $this->apiService->getUrl($this->price, 0);

			$this->template->calculatorUrl = $url;
		} catch (Exception $e) {
			$presenter->flashMessage('essox.calculator.urlFailed', Flashes::FLASH_DANGER);
		}

		if ($presenter->isAjax()) {
			$this->template->showModal            = true;
			$this->getPresenter()->payload->modal = 'essoxDialog';
			$this->redrawControl('calculatorDialog');
			$presenter->redrawControl('flashes');
		}
	}
}
