<?php declare(strict_types = 1);

namespace Essox\FrontModule\Components;

use Core\Model\UI\BaseControl;
use EshopOrders\Model\Entities\Order;
use Essox\Model\ApiService;

class EssoxPay extends BaseControl
{
	protected ?Order $order = null;

	protected ApiService $apiService;

	public function __construct(
		?Order     $order,
		ApiService $apiService
	)
	{
		$this->order      = $order;
		$this->apiService = $apiService;
	}

	public function render(): void
	{
		if (!$this->order) {
			return;
		}

		$link = $this->getPresenter()->link('//:EshopOrders:Front:Payment:paymentFinished', ['orderIdent' => $this->order->getIdent()]);

		$this->template->paymentUrl = $this->apiService->getPaymentUrl($this->order, $link);

		$this->template->render($this->getTemplateFile());
	}
}
