<?php declare(strict_types = 1);

namespace Essox\FrontModule\Model\Subscribers;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Event\PresenterTemplateEvent;
use EshopOrders\FrontModule\Presenters\PaymentPresenter;
use Essox\FrontModule\Components\IEssoxPayFactory;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class OrderPaymentSubscriber implements EventSubscriberInterface
{
	protected EntityManagerDecorator $em;
	protected IEssoxPayFactory       $payFactory;

	public function __construct(
		IEssoxPayFactory       $payFactory,
		EntityManagerDecorator $em
	)
	{
		$this->em         = $em;
		$this->payFactory = $payFactory;
	}

	/**
	 * @return string[]
	 */
	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.paymentPayAction' => 'paymentPayAction',
		];
	}

	public function paymentPayAction(PresenterTemplateEvent $event): void
	{
		/** @var PaymentPresenter $presenter */
		$presenter = $event->presenter;
		$order     = $presenter->order;

		if ($order->getPaymentIdent() !== 'essox') {
			return;
		}

		$presenter->addIncludeTemplate(__DIR__ . '/payAction.latte');
	}
}
