<?php declare(strict_types=1);

namespace Fio\AdminModule\Model;

use FioApi\Downloader;
use Nette\DI\InvalidConfigurationException;
use Nette\Utils\Strings;

class FioDownloader extends Downloader
{
	public function __construct(string $accountNumber, array $config)
	{
		$token = null;
		foreach ($config['accounts'] as $k => $a) {
			if (Strings::endsWith($k, '-read') && $a['account'] === $accountNumber) {
				$token = $a['token'];
				break;
			}
		}

		if (!$token) {
			throw new InvalidConfigurationException("FioDownloader: Token for account number: {$accountNumber} for reading not found");
		}

		if (empty(ini_get('curl.cainfo'))) {
			throw new InvalidConfigurationException('Please fill curl.cainfo in php.ini');
		} else {
			$this->setCertificatePath(ini_get('curl.cainfo'));
		}

		parent::__construct($token);
	}
}