<?php declare(strict_types=1);

namespace Fio\Model\Entities;

use DateTimeInterface;
use EshopCatalog\Model\Entities\SellerBankAccount;
use EshopPayments\Model\Entities\IPayment;

class FioPayment implements IPayment
{
	protected float $amount;
	protected ?DateTimeInterface $dateOfPayment;
	protected ?string $senderAccountNumber;
	protected ?string $senderBankCode;
	protected ?string $senderBankName;
	protected ?string $senderName;
	protected ?string $constantSymbol;
	protected ?string $variableSymbol;
	protected ?string $specificSymbol;
	protected ?string $userMessage;
	protected ?string $comment;
	protected string $paymentOrderId;
	protected SellerBankAccount $bankAccount;

	public function __construct(float $amount, string $paymentOrderId, SellerBankAccount $bankAccount)
	{
		$this->amount = $amount;
		$this->paymentOrderId = $paymentOrderId;
		$this->bankAccount = $bankAccount;
	}

	public function getAmount(): float
	{
		return $this->amount;
	}

	public function getDateOfPayment(): ?DateTimeInterface
	{
		return $this->dateOfPayment;
	}

	public function getSenderAccountNumber(): ?string
	{
		return $this->senderAccountNumber;
	}

	public function getSenderBankCode(): ?string
	{
		return $this->senderBankCode;
	}

	public function getSenderBankName(): ?string
	{
		return $this->senderBankName;
	}

	public function getSenderName(): ?string
	{
		return $this->senderName;
	}

	public function getConstantSymbol(): ?string
	{
		return $this->constantSymbol;
	}

	public function getVariableSymbol(): ?string
	{
		return $this->variableSymbol;
	}

	public function getSpecificSymbol(): ?string
	{
		return $this->specificSymbol;
	}

	public function getUserMessage(): ?string
	{
		return $this->userMessage;
	}

	public function getComment(): ?string
	{
		return $this->comment;
	}

	public function getPaymentOrderId(): ?string
	{
		return $this->paymentOrderId;
	}
	
	public function getBankAccount(): SellerBankAccount
	{
		return $this->bankAccount;
	}

	public function setAmount(float $amount): self
	{
		$this->amount = $amount;
		return $this;
	}

	public function setDateOfPayment(?DateTimeInterface $dateOfPayment): self
	{
		$this->dateOfPayment = $dateOfPayment;
		return $this;
	}

	public function setSenderAccountNumber(?string $senderAccountNumber): self
	{
		$this->senderAccountNumber = $senderAccountNumber;
		return $this;
	}

	public function setSenderBankCode(?string $senderBankCode): self
	{
		$this->senderBankCode = $senderBankCode;
		return $this;
	}

	public function setSenderBankName(?string $senderBankName): self
	{
		$this->senderBankName = $senderBankName;
		return $this;
	}

	public function setSenderName(?string $senderName): self
	{
		$this->senderName = $senderName;
		return $this;
	}

	public function setConstantSymbol(?string $constantSymbol): self
	{
		$this->constantSymbol = $constantSymbol;
		return $this;
	}

	public function setVariableSymbol(?string $variableSymbol): self
	{
		$this->variableSymbol = $variableSymbol;
		return $this;
	}

	public function setSpecificSymbol(?string $specificSymbol): self
	{
		$this->specificSymbol = $specificSymbol;
		return $this;
	}

	public function setUserMessage(?string $userMessage): self
	{
		$this->userMessage = $userMessage;
		return $this;
	}

	public function setComment(?string $comment): self
	{
		$this->comment = $comment;
		return $this;
	}

	public function setPaymentOrderId(?string $paymentOrderId): self
	{
		$this->paymentOrderId = $paymentOrderId;
		return $this;
	}

	public function setBankAccount(SellerBankAccount $bankAccount): self
	{
		$this->bankAccount = $bankAccount;
		return $this;
	}

}