<?php declare(strict_types = 1);

namespace Forms\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use Core\Model\ORM\Query;
use Doctrine\ORM\Query\Expr\Join;
use Forms\Model\Entities\Form;
use Forms\Model\FormsCache;
use Nette\Caching\Cache;
use Nette\Localization\Translator;

/**
 * @method Form|object|null getReference($id)
 * @method Form|object|null get($id)
 */
class Forms extends BaseEntityService
{
	use TPublish;

	protected $entityClass = Form::class;

	protected Translator $translator;
	protected FormsCache $formsCache;

	public function __construct(
		Translator $translator,
		FormsCache $formsCache
	)
	{
		$this->translator = $translator;
		$this->formsCache = $formsCache;
	}

	public function getOptionsForSelect(): array
	{
		$arr = [];

		foreach ($this->getEr()->createQueryBuilder('f')
			         ->select('f.id, ft.title')
			         ->innerJoin('f.texts', 'ft', Join::WITH, 'ft.lang = :lang')
			         ->setParameter('lang', $this->translator->getLocale())
			         ->getQuery()->getArrayResult() as $row)
			$arr[$row['id']] = $row['title'];

		return $arr;
	}

	/**
	 * Kontrola existence ident. Pokud neexistuje vrací true
	 *
	 * @param string   $ident
	 * @param int|null $currentFormId
	 *
	 * @return bool
	 * @throws \Doctrine\ORM\NonUniqueResultException
	 */
	public function validateFormIdent(string $ident, ?int $currentFormId = null): bool
	{
		$qb = $this->getEr()->createQueryBuilder('f')->select('count(f.id) as count')
			->where('f.ident = :ident')->setParameter('ident', $ident)
			->setMaxResults(1);

		if ($currentFormId)
			$qb->andWhere('f.id != :id')->setParameter('id', $currentFormId);

		return ($qb->getQuery()->getOneOrNullResult(Query::HYDRATE_ARRAY)['count'] ?? 0) <= 0;
	}

	public function remove($id)
	{
		$result = parent::remove($id);

		if ($result) {
			$this->formsCache->getCache()->clean([
				Cache::Tags => 'form',
			]);
		}

		return $result;
	}

}
