<?php declare(strict_types = 1);

namespace Forms\AdminModule\Presenters;

use Forms\AdminModule\Components\FormsGrid;
use Forms\AdminModule\Components\IFormsGridFactory;

class DefaultPresenter extends BasePresenter
{

	/*******************************************************************************************************************
	 * ==================================   Renders
	 */


	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault()
	{
		$this->setHeader('forms.title.forms', 'fab fa-wpforms');
		$this['navigation']->setData(['header' => [
			[
				'title' => 'forms.menu.newForm',
				'link'  => $this->link('formsGrid:add!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			],
		]]);
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentFormsGrid(IFormsGridFactory $factory): FormsGrid
	{
		return $factory->create();
	}
}
