<?php declare(strict_types = 1);

namespace Forms\ApiModule\Api\V1\BodyEntity;

use Apitte\Core\Exception\Api\ClientErrorException;
use Apitte\Core\Http\ApiRequest;
use Apitte\Core\Mapping\Request\BasicEntity;
use Nette\Utils\Json;
use Nette\Utils\JsonException;

class FormPost extends BasicEntity
{
	public ?int    $id     = null;
	public ?string $ident  = null;
	public string  $lang   = 'cs';
	public array   $values = [];

	protected function fromBodyRequest(ApiRequest $request): self
	{
		$result = [];

		try {
			$body = $request->getParsedBody();

			$result = [
				'id'     => $body['id'] ?? null,
				'ident'  => $body['ident'] ?? null,
				'lang'   => $body['lang'] ?? 'cs',
				'values' => Json::decode($body['values'], Json::FORCE_ARRAY),
			];
		} catch (JsonException $ex) {
			throw new ClientErrorException('Invalid json data', 400, $ex);
		}

		return $this->factory($result);
	}
}
