<?php declare(strict_types = 1);

namespace Forms\FrontModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Forms\Model\Entities\Form;
use Forms\Model\FormsCache;
use Nette\Caching\Cache;
use Forms\FrontModule\Model\Dao;

class Forms extends BaseEntityService
{
	protected $entityClass = Form::class;

	protected FormsCache $formsCache;

	protected array $cForms = [];

	public function __construct(
		FormsCache $formsCache
	)
	{
		$this->formsCache = $formsCache;
	}

	public function get($id): ?Form
	{
		if (!isset($this->cForms[$id])) {
			if (is_numeric($id)) {
				$this->cForms[$id] = parent::get($id);
			} else {
				$this->cForms[$id] = $this->getEr()->findOneBy(['ident' => $id]);
			}
		}

		return $this->cForms[$id];
	}

	public function getBasicData($id): ?Dao\Form
	{
		return $this->formsCache->getCache()->load('form_' . $id, function(&$dep) use ($id) {
			$dep = [
				Cache::Tags       => 'form',
				Cache::EXPIRATION => '1 week',
			];

			$entity = $this->get($id);

			return $entity ? Dao\Form::fromEntity($entity) : null;
		});
	}
}
