<?php declare(strict_types = 1);

namespace Forms\Model\Entities;

use Core\Model\Entities\TId;
use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="forms__field")
 * @ORM\Entity
 */
class Field
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="Form", inversedBy="fields")
	 * @ORM\JoinColumn(name="form_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Form $form;

	/**
	 * @ORM\Column(name="title", type="string", length=255)
	 */
	public string $type;

	/**
	 * @ORM\Column(name="name", type="string", length=255)
	 */
	public ?string $name = null;

	/**
	 * @ORM\Column(name="params", type="array")
	 */
	public array $params = [];

	public function __construct(Form $form, string $type, ?string $name = null)
	{
		$this->form = $form;
		$this->type = $type;
		$this->name = $name;
	}

}
