<?php declare(strict_types = 1);

namespace Forms\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="forms__form_text")
 * @ORM\Entity
 */
class FormText
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Form", inversedBy="texts")
	 * @ORM\JoinColumn(name="form_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Form $form;

	/**
	 * @ORM\Id
	 * @ORM\Column(name="lang", type="string", length=2, nullable=true)
	 */
	public string $lang;

	/**
	 * @ORM\Column(name="title", type="string", length=255)
	 */
	public string $title;

	/**
	 * @ORM\Column(name="user_email_subject", type="string", length=255)
	 */
	public string $userEmailSubject;

	/**
	 * @ORM\Column(name="admin_email_subject", type="string", length=255)
	 */
	public string $adminEmailSubject;

	/**
	 * @ORM\Column(name="user_email_content", type="text", nullable=true)
	 */
	public ?string $userEmailContent = null;

	/**
	 * @ORM\Column(name="user_email_confirm", type="text", nullable=true)
	 */
	public ?string $userEmailConfirm = null;

	/**
	 * @ORM\Column(name="admin_email_content", type="text", nullable=true)
	 */
	public ?string $adminEmailContent = null;

	/**
	 * @ORM\Column(name="message_after_send", type="text", nullable=true)
	 */
	public ?string $messageAfterSend = null;

	public function __construct(Form $form, string $lang, string $title)
	{
		$this->form  = $form;
		$this->lang  = $lang;
		$this->title = $title;
	}
}
