<?php declare(strict_types = 1);

namespace Forms\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table(name="forms__submission")
 * @ORM\Entity
 */
class Submission
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="Form", inversedBy="submissions")
	 * @ORM\JoinColumn(name="form_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Form $form;

	/**
	 * @ORM\Column(name="subject", type="string", nullable=true)
	 */
	public string $subject;

	/**
	 * @ORM\Column(name="lang", type="string", length=2, nullable=false)
	 */
	public string $lang = 'cs';

	/**
	 * @Gedmo\Timestampable(on="create")
	 * @ORM\Column(name="created", type="datetime")
	 */
	private \DateTimeInterface $created;

	/**
	 * @ORM\Column(name="confirmed", type="smallint", options={"unsigned": true, "default": 0})
	 */
	public int $confirmed = 0;

	/**
	 * @ORM\Column(name="confirmation_email_sent", type="smallint", options={"unsigned": true, "default": 0})
	 */
	public int $confirmationEmailSent = 0;

	/**
	 * @var SubmissionField[]|ArrayCollection
	 * @ORM\OneToMany(targetEntity="SubmissionField", mappedBy="submission")
	 */
	public $fields;

	/**
	 * @ORM\Column(name="email_content", type="text", nullable=true)
	 */
	public ?string $emailContent = null;

	/**
	 * @ORM\Column(name="confirm_email_content", type="text", nullable=true)
	 */
	public ?string $confirmEmailContent = null;

	/**
	 * @ORM\Column(name="url", type="text", nullable=true)
	 */
	public ?string $url = null;

	/**
	 * @ORM\Column(name="user_data", type="text", nullable=true)
	 */
	public ?string $userData = null;

	public function __construct($form)
	{
		$this->form = $form;

		$this->fields = new ArrayCollection();
	}

	public function getCreated(): \DateTimeInterface { return $this->created; }
}
