<?php declare(strict_types = 1);

namespace Forms\Model;

use Core\Model\Router\RouteHelper;
use Core\Model\Router\RouteList;

class RouterFactory
{
	/** @var RouteHelper */
	protected $routeHelper;

	public function __construct(RouteHelper $routeHelper)
	{
		$this->routeHelper = $routeHelper;
	}

	public function createRouter()
	{
		$router = new RouteList;

		$front   = $router[] = new RouteList('Forms:Front');
		$front[] = $this->routeHelper->createRoute('/forms/confirm/<id>', 'Default:confirm');

		return $router;
	}
}
