<?php declare(strict_types = 1);

namespace Forms\Model\TemplateTextType;

use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Core\Model\UI\Form\BaseContainer;
use Forms\FrontModule\Components\IFormControlFactory;
use Forms\FrontModule\Model\Forms as FrontForms;
use Forms\AdminModule\Model\Forms as AdminForms;
use Nette\Localization\Translator;

class Forms extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'form';

	protected FrontForms $forms;

	protected AdminForms $adminForms;

	protected Translator $translator;

	public function __construct(FrontForms $forms, AdminForms $adminForms, Translator $translator)
	{
		$this->forms      = $forms;
		$this->adminForms = $adminForms;
		$this->translator = $translator;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$formContainer->addSelect($this->getName(), $this->getTitle(), [null => ''] + $this->adminForms->getOptionsForSelect());
	}

	public function render($params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		return $this->getDefault() ? (int) $this->getDefault() : null;
	}
}
