<?php declare(strict_types = 1);

namespace Forms\AdminModule\Presenters;

use Forms\AdminModule\Components\DisallowedKeywordsGrid;
use Forms\AdminModule\Components\IDisallowedKeywordsGridFactory;
use Forms\Model\FormsConfig;

class DisallowedKeywordsPresenter extends BasePresenter
{
	protected function startup(): void
	{
		parent::startup();

		if (!FormsConfig::load('enableKeywordCaptcha')) {
			$this->error();
		}
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */
	public function actionDefault(): void
	{
		$this->setHeader('forms.title.disallowedKeywords', 'fas fa-key');
		$this['navigation']->setData(['header' => [
			[
				'title' => 'forms.menu.newDisallowedKeyword',
				'link'  => $this->link('disallowedKeywordsGrid:add!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			],
			[
				'title' => 'forms.menu.forms',
				'link'  => 'Default:',
				'ico'   => 'fab fa-wpforms',
			],
		]]);
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	public function createComponentDisallowedKeywordsGrid(IDisallowedKeywordsGridFactory $factory,
	): DisallowedKeywordsGrid
	{
		return $factory->create();
	}

}
