<?php declare(strict_types = 1);

namespace Forms\DI;

use Exception;
use Core\DI\CompilerExtension;
use Nette\PhpGenerator\ClassType;
use Override;

class FormsExtension extends CompilerExtension
{

	#[Override]
	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	#[Override]
	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['Forms' => 'Forms\*Module\Presenters\*Presenter']);

		if (file_exists(TEMPLATES_DIR . '/Front/default/Forms/EmailTemplates/')) {
			$dir = TEMPLATES_DIR . '/Front/default/Forms/EmailTemplates/';
			throw new Exception("Form directory '{$dir}' is deprecated. Rename folder to 'FormTemplates' or delete it.");
		}
	}

	#[Override]
	public function afterCompile(ClassType $class): void
	{
		parent::afterCompile($class);
		$init    = $class->getMethod('initialize');
		$builder = $this->getContainerBuilder();

		$init->addBody('Forms\Model\FormsConfig::setParams(?);', [$builder->parameters['forms']]);
	}
}
