<?php declare(strict_types = 1);

namespace Forms\FrontModule\Presenters;

use Forms\FrontModule\Model\Submissions;
use Nette\DI\Attributes\Inject;

class DefaultPresenter extends BasePresenter
{
	#[Inject]
	public Submissions $submissions;

	public function actionConfirm(int $id): void
	{
		$this['title']->setTitle($this->translator->translate('formsFront.title.confirmation'), false);
		$this['meta']->setMeta('robots', 'noindex,nofollow');
		$this->submissions->confirm($id);
	}
}
