<?php declare(strict_types = 1);

namespace Forms\Model\Entities;

use Core\Model\Entities\TId;
use Core\Model\Entities\TranslateListener;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'forms__disallowed_keyword')]
#[ORM\Entity]
#[ORM\EntityListeners([TranslateListener::class])]
class DisallowedKeyword
{
	use TId;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $word;

	public function __construct(string $word)
	{
		$this->word = $word;
	}

}
