<?php declare(strict_types = 1);

namespace Forms\Model;

use Nette\Caching\Cache;
use Nette\Caching\Storage;

class FormsCache
{
	final public const cacheNamespace = 'forms';

	protected Cache $cache;

	public function __construct(Storage $storage)
	{
		$this->cache = new Cache($storage, self::cacheNamespace);
	}

	/**
	 * @param string|int $ident
	 */
	public static function getKey($ident, string $lang): string
	{
		return implode('/', ['form', $ident, $lang]);
	}

	public function getCache(): Cache { return $this->cache; }
}
