<?php declare(strict_types = 1);

namespace Forms\Model;

use Core\Model\Router\RouteHelper;
use Core\Model\Router\RouteList;

class RouterFactory
{
	public function __construct(protected RouteHelper $routeHelper)
	{
	}

	public function createRouter(): RouteList
	{
		$router = new RouteList;

		$front   = $router[] = new RouteList('Forms:Front');
		$front[] = $this->routeHelper->createRoute('/forms/confirm/<id>', 'Default:confirm');

		return $router;
	}
}
