<?php declare(strict_types = 1);

namespace Forms\AdminModule\Model;

use Contributte\Translation\Translator;
use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use Doctrine\ORM\AbstractQuery;
use Doctrine\ORM\NonUniqueResultException;
use Doctrine\ORM\Query\Expr\Join;
use Forms\Model\Entities\Form;
use Forms\Model\FormsCache;
use Nette\Caching\Cache;

/**
 * @method Form|object|null getReference($id)
 * @method Form|object|null get($id)
 */
class Forms extends BaseEntityService
{
	use TPublish;

	protected $entityClass = Form::class;

	protected Translator $translator;
	protected FormsCache $formsCache;

	public function __construct(
		Translator $translator,
		FormsCache $formsCache
	)
	{
		$this->translator = $translator;
		$this->formsCache = $formsCache;
	}

	/**
	 * @return string[]
	 */
	public function getOptionsForSelect(): array
	{
		$arr = [];

		foreach ($this->getEr()->createQueryBuilder('f')
			         ->select('f.id, ft.title')
			         ->innerJoin('f.texts', 'ft', Join::WITH, 'ft.lang = :lang')
			         ->setParameter('lang', $this->translator->getLocale())
			         ->getQuery()->getArrayResult() as $row) {
			$arr[$row['id']] = $row['title'];
		}

		return $arr;
	}

	/**
	 * Kontrola existence ident. Pokud neexistuje vrací true
	 *
	 * @throws NonUniqueResultException
	 */
	public function validateFormIdent(string $ident, ?int $currentFormId = null): bool
	{
		$qb = $this->getEr()->createQueryBuilder('f')->select('count(f.id) as count')
			->where('f.ident = :ident')->setParameter('ident', $ident)
			->setMaxResults(1);

		if ($currentFormId) {
			$qb->andWhere('f.id != :id')->setParameter('id', $currentFormId);
		}

		return ($qb->getQuery()->getOneOrNullResult(AbstractQuery::HYDRATE_ARRAY)['count'] ?? 0) <= 0;
	}

	/**
	 * @param int $id
	 */
	public function remove($id): bool
	{
		$result = parent::remove($id);

		if ($result) {
			$this->formsCache->getCache()->clean([
				Cache::Tags => 'form',
			]);
		}

		return $result;
	}

}
