<?php declare(strict_types = 1);

namespace Forms\AdminModule\Presenters;

use Core\Model\Sites;
use Forms\AdminModule\Components\FormsGrid;
use Forms\AdminModule\Components\IFormsGridFactory;
use Forms\Model\FormsConfig;
use Nette\Security\Passwords;

class DefaultPresenter extends BasePresenter
{
	protected Sites $sites;

	/**
	 * @param Sites $sites
	 */
	public function __construct(
		Sites $sites
	)
	{
		$this->sites = $sites;
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault(): void
	{
		$this->setHeader('forms.title.forms', 'fab fa-wpforms');
		$data = [
			[
				'title' => 'forms.menu.newForm',
				'link'  => $this->link('formsGrid:add!'),
				'ico'   => 'plus',
				'class' => 'ajax',
			],
		];

		if (FormsConfig::load('enableKeywordCaptcha')) {
			$data[] = [
				'title' => 'forms.menu.disallowedKeywords',
				'link'  => 'DisallowedKeywords:default',
				'ico'   => 'fas fa-key',
			];
		}
		$this['navigation']->setData(['header' => $data]);


		if ($this->getUser()->isAllowed('Forms:Admin', 'showExportUrl')) {
			$password = new Passwords();
			$keys     = [];
			foreach ($this->sites->getSites() as $k => $site) {
				$domains = [];
				foreach ($site->getDomains() as $domain) {
					if (!$domain->getDomain()) {
						continue;
					}

					$domains[] = $domain->getLang() . ' - ' . $domain->getDomain();
				}

				$keys[] = [
					'ident'   => $site->getIdent(),
					'domains' => $domains,
					'key'     => $password->hash(FormsConfig::load('exportUrlHash') . $site->getIdent()),
				];
			}

			$this->template->keys = $keys;
		}
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentFormsGrid(IFormsGridFactory $factory): FormsGrid
	{
		return $factory->create();
	}

}
