<?php declare(strict_types = 1);

namespace Forms\ApiModule\Api\V1\Controllers;

use Apitte\Core\Annotation\Controller\Method;
use Apitte\Core\Annotation\Controller\Path;
use Apitte\Core\Http\ApiRequest;
use Apitte\Core\Http\ApiResponse;
use Apitte\Negotiation\Http\ArrayEntity;
use Apitte\Core\Annotation\Controller\RequestBody;
use Contributte\Translation\Translator;
use Exception;
use Forms\ApiModule\Api\V1\BodyEntity\FormPost;
use Forms\FrontModule\Model\FormProcess;
use Forms\FrontModule\Model\Forms;
use Nette\Utils\ArrayHash;

/**
 * @Path("/")
 */
class FormController extends BaseController
{
	protected Forms       $forms;
	protected FormProcess $formProcess;
	protected Translator  $translator;

	public function __construct(
		Forms       $forms,
		FormProcess $formProcess,
		Translator  $translator
	)
	{
		$this->forms       = $forms;
		$this->formProcess = $formProcess;
		$this->translator  = $translator;
	}

	/**
	 * @Path("/")
	 * @Method("POST")
	 * @RequestBody(entity="Forms\ApiModule\Api\V1\BodyEntity\FormPost")
	 */
	public function postForm(ApiRequest $request, ApiResponse $response): ApiResponse
	{
		error_reporting(~E_USER_DEPRECATED & ~E_WARNING & ~E_NOTICE & ~E_USER_WARNING & ~E_USER_NOTICE);

		/** @var FormPost $data */
		$data = $request->getEntity();
		if (($data->id || $data->ident) && !empty($data->values)) {
			$this->translator->setLocale($data->lang);

			try {
				$form      = $this->forms->get($data->id ?: $data->ident);
				$arrayHash = ArrayHash::from($data->values);

				if (!$form) {
					throw new Exception('Form not found');
				}

				$uploadedFiles = $request->getUploadedFiles();
				if ($uploadedFiles) {
					$files            = $this->formProcess->uploadFiles($uploadedFiles);
					$arrayHash->files = $files;
				}

				$submission = $this->formProcess->createSubmission(
					$arrayHash,
					$form,
				);

				if (!$submission) {
					throw new Exception('Submission not created');
				}

				$this->formProcess->sendUser(
					$arrayHash,
					$form,
					$submission,
				);

				$this->formProcess->sendAdmin(
					$arrayHash,
					$form,
				);

				return $response->withStatus(ApiResponse::S200_OK)->withEntity(ArrayEntity::from([
					'thankYouMessage' => $form->getText()->messageAfterSend,
				]));
			} catch (Exception $e) {
				return $response->withStatus(ApiResponse::S200_OK)->withEntity(ArrayEntity::from([
					'error' => $e->getMessage(),
				]));
			}
		}

		return $response->withStatus(ApiResponse::S200_OK)->withEntity(ArrayEntity::from([
			'error' => '',
		]));
	}
}
