<?php declare(strict_types = 1);

namespace Forms\DI;

use Core\DI\CompilerExtension;
use Nette;

class FormsExtension extends CompilerExtension
{

	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Forms' => 'Forms\*Module\Presenters\*Presenter']);

		if (file_exists(TEMPLATES_DIR . '/Front/default/Forms/EmailTemplates/')) {
			$dir = TEMPLATES_DIR . '/Front/default/Forms/EmailTemplates/';
			throw new \Exception("Form directory '{$dir}' is deprecated. Rename folder to 'FormTemplates' or delete it.");
		}
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init    = $class->methods["initialize"];
		$builder = $this->getContainerBuilder();

		$init->addBody('Forms\Model\FormsConfig::setParams(?);', [$builder->parameters['forms']]);
	}
}
