<?php declare(strict_types = 1);

namespace Forms\FrontModule\Model\Dao;

class Form
{
	public ?string $ident                = null;
	public ?string $template             = null;
	public ?string $userFromEmail        = null;
	public ?string $userFromName         = null;
	public ?string $userToEmail          = null;
	public ?string $userToName           = null;
	public ?string $userBc               = null;
	public ?string $userBcc              = null;
	public ?string $userReply            = null;
	public ?string $adminFromEmail       = null;
	public ?string $adminFromName        = null;
	public ?string $adminToEmail         = null;
	public ?string $adminToName          = null;
	public ?string $adminReply           = null;
	public int     $sendUserEmail        = 1;
	public int     $sendUserEmailConfirm = 0;
	public int     $sendAdminEmail       = 0;
	public array   $measuringCodes       = [];
	public ?string $title                = null;
	public ?array  $settings             = null;

	public static function fromEntity(\Forms\Model\Entities\Form $entity): self
	{
		$dao                       = new self;
		$dao->ident                = $entity->getIdent();
		$dao->template             = $entity->template;
		$dao->userFromEmail        = $entity->userFromEmail;
		$dao->userFromName         = $entity->userFromName;
		$dao->userToEmail          = $entity->userToEmail;
		$dao->userToName           = $entity->userToName;
		$dao->userBc               = $entity->userBc;
		$dao->userBcc              = $entity->userBcc;
		$dao->userReply            = $entity->userReply;
		$dao->adminFromEmail       = $entity->adminFromEmail;
		$dao->adminFromName        = $entity->adminFromName;
		$dao->adminToEmail         = $entity->adminToEmail;
		$dao->adminToName          = $entity->adminToName;
		$dao->adminReply           = $entity->adminReply;
		$dao->sendUserEmail        = $entity->sendUserEmail;
		$dao->sendUserEmailConfirm = $entity->sendUserEmailConfirm;
		$dao->sendAdminEmail       = $entity->sendAdminEmail;
		$dao->title                = $entity->getText()->title;
		$dao->measuringCodes       = $entity->getMeasuringCodesByKey();
		$dao->settings             = $entity->settings;

		return $dao;
	}
}
