<?php declare(strict_types = 1);

namespace Forms\FrontModule\Model;

use Contributte\Translation\Translator;
use Core\Model\Helpers\BaseEntityService;
use Forms\FrontModule\Model\Dao;
use Forms\Model\Entities\Form;
use Forms\Model\FormsCache;
use Nette\Caching\Cache;
use Throwable;

class Forms extends BaseEntityService
{
	protected            $entityClass = Form::class;
	protected FormsCache $formsCache;
	protected Translator $translator;

	protected array $cForms = [];

	public function __construct(
		FormsCache $formsCache,
		Translator $translator
	)
	{
		$this->formsCache = $formsCache;
		$this->translator = $translator;
	}

	/**
	 * @param int|string $id
	 */
	public function get($id): ?Form
	{
		if (!isset($this->cForms[$id])) {
			if (is_numeric($id)) {
				$this->cForms[$id] = parent::get($id);
			} else {
				$this->cForms[$id] = $this->getEr()->findOneBy(['ident' => $id]);
			}
		}

		return $this->cForms[$id];
	}

	/**
	 * @param int|string $id
	 *
	 * @throws Throwable
	 */
	public function getBasicData($id): ?Dao\Form
	{
		$lang = $this->translator->getLocale();

		return $this->formsCache->getCache()->load(FormsCache::getKey($id, $lang), function(&$dep) use ($id) {
			$dep = [
				Cache::Tags       => 'form',
				Cache::EXPIRATION => '1 week',
			];

			$entity = $this->get($id);

			return $entity ? Dao\Form::fromEntity($entity) : null;
		});
	}

}
