<?php declare(strict_types = 1);

namespace Forms\FrontModule\Presenters;

use Forms\FrontModule\Model\Submissions;

class DefaultPresenter extends BasePresenter
{
	/** @var Submissions|null @inject */
	public ?Submissions $submissions = null;

	public function actionConfirm(int $id): void
	{
		$this['title']->setTitle($this->translator->translate('formsFront.title.confirmation'), false);
		$this['meta']->setMeta('robots', 'noindex,nofollow');
		$this->submissions->confirm($id);
	}
}
