<?php declare(strict_types = 1);

namespace Forms\Model;

use Core\Model\Helpers\BaseEntityService;
use Forms\Model\Entities\DisallowedKeyword;
use Nette\Caching\Cache;
use Nette\Utils\Json;
use Tracy\Debugger;

/**
 * @method DisallowedKeyword|null getReference($id)
 * @method DisallowedKeyword|null get($id)
 */
class DisallowedKeywords extends BaseEntityService
{
	protected $entityClass = DisallowedKeyword::class;
	protected DisallowedKeywordsCache $disallowedKeywordsCache;

	public function __construct(DisallowedKeywordsCache $disallowedKeywordsCache)
	{
		$this->disallowedKeywordsCache = $disallowedKeywordsCache;
	}

	public function getAllWithExternals(): array
	{
		try {
			return $this->disallowedKeywordsCache->getCache()->load('disallowedKeywords', function(&$dep) {
				$dep = [
					Cache::Tags       => 'disallowedKeyword',
					Cache::EXPIRATION => '30 min',
				];

				$qb = $this->getEr()->createQueryBuilder('dk');
				$qb->select('dk.id, dk.word');
				$defaults = $qb->getQuery()->getArrayResult();

				if (FormsConfig::load('enableKeywordCaptchaEvidenceResource', false)) {
					$json = file_get_contents('https://api-evidence.pshk.cz/v1/cms/keywords');
					$data = Json::decode($json, Json::FORCE_ARRAY);

					if ($data['status'] !== 'success') {
						return [];
					}
				} else {
					$data['data'] = [];
				}

				$result = [];
				$words = [];
				foreach ($defaults as $v) {
					$result[] = [
						'id'   => $v['id'],
						'word' => $v['word']
					];
					$words[] = $v['word'];
				}

				foreach ($data['data'] as $v) {
					if (in_array($v, $words, true)) {
						continue;
					}
					$result[] = [
						'id'   => null,
						'word' => $v
					];
				}

				return $result;
			});

		} catch (\Exception $e) {
			Debugger::log($e);
			return [];
		}
	}

	/**
	 * @param int $id
	 */
	public function remove($id): bool
	{
		$result = parent::remove($id);

		if ($result) {
			$this->disallowedKeywordsCache->getCache()->clean([
				Cache::Tags => 'disallowedKeyword',
			]);
		}

		return $result;
	}

}