<?php declare(strict_types = 1);

namespace Forms\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="forms__disallowed_keyword")
 * @ORM\Entity
 * @ORM\EntityListeners({"Core\Model\Entities\TranslateListener"})
 */
class DisallowedKeyword
{
	use TId;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $word;

	public function __construct(string $word)
	{
		$this->word = $word;
	}

}