<?php declare(strict_types = 1);

namespace Forms\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="forms__form_measuring_codes")
 * @ORM\Entity
 */
class FormMeasuringCodes
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="Form", inversedBy="measuringCodes")
	 * @ORM\JoinColumn(name="form_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Form $form;

	/**
	 * @ORM\Column(type="string", length=4, nullable=true)
	 */
	public ?string $locale = null;

	/**
	 * @ORM\Column(name="`key`", type="string", length=255, nullable=false)
	 */
	public string $key;

	/**
	 * @ORM\Column(name="name", type="string", length=255, nullable=true)
	 */
	public ?string $value = null;

	public function __construct(Form $form, string $key)
	{
		$this->form = $form;
		$this->key  = $key;
	}

}
