<?php declare(strict_types = 1);

namespace Forms\Model\Entities;

use Core\Model\Entities\TId;
use DateTimeInterface;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table(name="forms__submission")
 * @ORM\Entity
 */
class Submission
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="Form", inversedBy="submissions")
	 * @ORM\JoinColumn(name="form_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Form $form;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $subject = null;

	/**
	 * @ORM\Column(type="string", length=2, nullable=false)
	 */
	public string $lang = 'cs';

	/**
	 * @Gedmo\Timestampable(on="create")
	 * @ORM\Column(type="datetime")
	 */
	private DateTimeInterface $created;

	/**
	 * @ORM\Column(type="smallint", options={"unsigned": true, "default": 0})
	 */
	public int $confirmed = 0;

	/**
	 * @ORM\Column(type="smallint", options={"unsigned": true, "default": 0})
	 */
	public int $confirmationEmailSent = 0;

	/**
	 * @var Collection<SubmissionField>
	 * @ORM\OneToMany(targetEntity="SubmissionField", mappedBy="submission")
	 */
	public Collection $fields;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	public ?string $emailContent = null;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	public ?string $confirmEmailContent = null;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	public ?string $url = null;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	public ?string $userData = null;

	/**
	 * @ORM\Column(type="smallint", options={"default":0})
	 */
	public int $isSpam = 0;

	/**
	 * @ORM\Column(type="smallint", options={"default":0})
	 */
	public int $completed = 0;

	public function __construct(Form $form)
	{
		$this->form   = $form;
		$this->fields = new ArrayCollection;
	}

	public function getCreated(): DateTimeInterface { return $this->created; }

	public function getSubmissionFieldByName(string $name): ?SubmissionField
	{
		foreach ($this->fields as $field) {
			if ($field->name === $name) {
				return $field;
			}
		}

		return null;
	}
}
