<?php declare(strict_types = 1);

namespace Forms\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="forms__submission_field")
 * @ORM\Entity
 */
class SubmissionField
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="Field")
	 * @ORM\JoinColumn(name="field_id", referencedColumnName="id", onDelete="CASCADE", nullable=true)
	 */
	public ?Field $field = null;

	/**
	 * @ORM\ManyToOne(targetEntity="Submission", inversedBy="fields", cascade={"persist"})
	 * @ORM\JoinColumn(name="submission_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Submission $submission;

	/**
	 * @ORM\Column(name="name", type="string")
	 */
	public string $name;

	/**
	 * @ORM\Column(name="value", type="text")
	 */
	public string $value;

	public function __construct(Submission $submission, string $name, string $value)
	{
		$this->submission = $submission;
		$this->name       = $name;
		$this->value      = $value;
	}

}
