<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20210125173634 extends AbstractMigration
{
	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('CREATE TABLE forms__field (id INT AUTO_INCREMENT NOT NULL, form_id INT DEFAULT NULL, title VARCHAR(255) NOT NULL, name VARCHAR(255) NOT NULL, params LONGTEXT NOT NULL COMMENT \'(DC2Type:array)\', INDEX IDX_B74B59655FF69B7D (form_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE forms__form (id INT AUTO_INCREMENT NOT NULL, is_published SMALLINT DEFAULT 1 NOT NULL, user_from_email VARCHAR(255) DEFAULT NULL, user_from_name VARCHAR(255) DEFAULT NULL, user_to_email VARCHAR(255) DEFAULT NULL, user_to_name VARCHAR(255) DEFAULT NULL, user_bc VARCHAR(255) DEFAULT NULL, user_bcc VARCHAR(255) DEFAULT NULL, user_reply VARCHAR(255) DEFAULT NULL, user_email_content LONGTEXT DEFAULT NULL, admin_from_email VARCHAR(255) DEFAULT NULL, admin_from_name VARCHAR(255) DEFAULT NULL, admin_to_email VARCHAR(255) DEFAULT NULL, admin_to_name VARCHAR(255) DEFAULT NULL, admin_email_content LONGTEXT DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE forms__form_text (lang VARCHAR(2) NOT NULL, form_id INT NOT NULL, title VARCHAR(255) NOT NULL, user_email_subject VARCHAR(255) NOT NULL, admin_email_subject VARCHAR(255) NOT NULL, user_email_content LONGTEXT DEFAULT NULL, admin_email_content LONGTEXT DEFAULT NULL, INDEX IDX_6B2DF4DD5FF69B7D (form_id), PRIMARY KEY(form_id, lang)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE forms__submission (id INT AUTO_INCREMENT NOT NULL, form_id INT DEFAULT NULL, subject VARCHAR(255) NOT NULL, created DATETIME NOT NULL, confirmed SMALLINT UNSIGNED DEFAULT 0 NOT NULL, confirmation_email_sent SMALLINT UNSIGNED DEFAULT 0 NOT NULL, INDEX IDX_A570A1195FF69B7D (form_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE forms__submission_field (id INT AUTO_INCREMENT NOT NULL, field_id INT DEFAULT NULL, submission_id INT DEFAULT NULL, value LONGTEXT NOT NULL, INDEX IDX_CDF73A6443707B0 (field_id), INDEX IDX_CDF73A6E1FD4933 (submission_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE forms__field ADD CONSTRAINT FK_B74B59655FF69B7D FOREIGN KEY (form_id) REFERENCES forms__form (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE forms__form_text ADD CONSTRAINT FK_6B2DF4DD5FF69B7D FOREIGN KEY (form_id) REFERENCES forms__form (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE forms__submission ADD CONSTRAINT FK_A570A1195FF69B7D FOREIGN KEY (form_id) REFERENCES forms__form (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE forms__submission_field ADD CONSTRAINT FK_CDF73A6443707B0 FOREIGN KEY (field_id) REFERENCES forms__field (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE forms__submission_field ADD CONSTRAINT FK_CDF73A6E1FD4933 FOREIGN KEY (submission_id) REFERENCES forms__submission (id) ON DELETE CASCADE');
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE forms__submission_field DROP FOREIGN KEY FK_CDF73A6443707B0');
		$this->addSql('ALTER TABLE forms__field DROP FOREIGN KEY FK_B74B59655FF69B7D');
		$this->addSql('ALTER TABLE forms__form_text DROP FOREIGN KEY FK_6B2DF4DD5FF69B7D');
		$this->addSql('ALTER TABLE forms__submission DROP FOREIGN KEY FK_A570A1195FF69B7D');
		$this->addSql('ALTER TABLE forms__submission_field DROP FOREIGN KEY FK_CDF73A6E1FD4933');
		$this->addSql('DROP TABLE forms__field');
		$this->addSql('DROP TABLE forms__form');
		$this->addSql('DROP TABLE forms__form_text');
		$this->addSql('DROP TABLE forms__submission');
		$this->addSql('DROP TABLE forms__submission_field');
	}
}
